#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/12/04
@file: record_sys_disk_fault_type.py
@function: 记录系统盘故障类型（单盘故障/双盘故障）
@modify:
"""
from py.common.entity.exception import BusinessException
from py.common.service import resource_service
from py.fusion_cube.common.constant import NODE_SYS_DISKS
from py.fusion_cube.common.context import disk_context_util
from py.fusion_cube.common.service.disk_init_factory.init_service_factory import \
    DiskInitServiceFactory

HEALTH_STATUS = 0
IS_SINGLE_SYS_FAULT = "IS_SINGLE_SYS_FAULT"


def record(context):
    node_disks = DiskInitServiceFactory(context).get_sys_init_service()\
        .query_node_sys_disks(disk_context_util.get_belong_mgmt_ip(context))
    context.getEnv()[NODE_SYS_DISKS] = node_disks
    cur_esn = disk_context_util.get_disk_sn(context)
    if len(node_disks) < 2:
        # 节点系统盘总数小于2，不支持更换
        raise BusinessException(
            resource_service.get_msg('replace.sys.disk.less.two.failed'))
    for disk in node_disks:
        if disk.getEsn() != cur_esn and disk.getStatus() != HEALTH_STATUS:
            context.getEnv()[IS_SINGLE_SYS_FAULT] = False
            # 暂不支持其他系统盘同时故障
            raise BusinessException(resource_service.get_msg(
                'replace.sys.disk.not.support.two.fault'))
    context.getEnv()[IS_SINGLE_SYS_FAULT] = True
