#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/07/16
@file: add_disk_to_pool_service.py
@function: 将盘加入存储池api，不涉及的接口参数为体现，详细可以在omrp上看对应接口
参数说明
@modify:
"""
SAS_SATA_TYPES = ("SAS_DISK", "SATA_DISK", "SSD_DISK")
NVME_SSD_TYPES = ("SSD_CARD", )
SSD_TYPES = ("SSD_DISK", "SSD_CARD")


def add_single_disks_to_pool(rest_service, pool_ids, mgmt_ip, disks):
    for pool_id in pool_ids:
        rest_service.exec_post(
            "/dsware/service/cluster/storagepool/replaceSingleDisk",
            {"nodeMgrIp": mgmt_ip,
             "id": pool_id,
             "slot": [disk.getSlotNo() for disk in disks]}
        )


def add_disk_to_pool(rest_service, pool_ids, old_disk, new_disk):
    if old_disk.getMediaType().toString() in SAS_SATA_TYPES:
        for pool_id in pool_ids:
            rest_service.exec_post(
                "/dsware/service/cluster/storagepool/replaceSingleDisk",
                {"nodeMgrIp": old_disk.getBelongNodeIp(),
                 "id": pool_id,
                 "slot": [new_disk.getSlotNo()]}
            )
    elif old_disk.getMediaType().toString() in NVME_SSD_TYPES:
        for pool_id in pool_ids:
            rest_service.exec_post(
                "/dsware/service/cluster/storagepool/replaceSSD",
                {"nodeMgrIp": old_disk.getBelongNodeIp(),
                 "id": pool_id,
                 "esn": ["{}:{}".format(old_disk.getEsn(), new_disk.getEsn())]}
            )


def force_add_main_disk_to_pool(rest_service, pool_ids, old_disk, new_disk):
    if old_disk.getMediaType().toString() in SAS_SATA_TYPES:
        for pool_id in pool_ids:
            rest_service.exec_post(
                "/dsware/service/cluster/storagepool/forceReplaceSingleDisk",
                {"nodeMgrIp": old_disk.getBelongNodeIp(),
                 "id": pool_id,
                 "slot": new_disk.getSlotNo(),
                 "ignoreMediaFault": "true"}
            )
    elif old_disk.getMediaType().toString() in NVME_SSD_TYPES:
        for pool_id in pool_ids:
            rest_service.exec_post(
                "/dsware/service/cluster/storagepool/forceReplaceSSD",
                {"nodeMgrIp": old_disk.getBelongNodeIp(),
                 "id": pool_id,
                 "newEsn": new_disk.getEsn(),
                 "oldEsn": old_disk.getEsn(),
                 "ignoreMediaFault": "true",
                 "type": "main_storage"}
            )


def force_add_ssd_card_to_pool(rest_service, old_disk, new_disk, _type,
                               ignore_media_fault="true"):
    """
    强制加入ssd到存储池
    :param rest_service: CubeRestService
    :param old_disk: 旧盘 BaseDisk
    :param new_disk: 新盘 BaseDisk
    :param _type: 盘角色。“main_storage”：主存。“cache”：缓存。 str
    :param ignore_media_fault: 是否忽略故障介质。“true”：是。“false”：否 str
    """
    if old_disk.getMediaType().toString() in SSD_TYPES:
        for pool_id in old_disk.getBelongPoolIds():
            rest_service.exec_post(
                "/dsware/service/cluster/storagepool/forceReplaceSSD",
                {"nodeMgrIp": new_disk.getBelongNodeIp(),
                 "id": pool_id,
                 "newEsn": new_disk.getEsn(),
                 "oldEsn": old_disk.getEsn(),
                 "ignoreMediaFault": ignore_media_fault,
                 "type": _type}
            )


def update_ssd_cache_esn(rest_service, old_disk, new_disk):
    if old_disk.getMediaType().toString() in SSD_TYPES:
        for pool_id in old_disk.getBelongPoolIds():
            rest_service.exec_post(
                "/dsware/service/cluster/storagepool/updateSSDCacheESN",
                {"nodeMgrIp": old_disk.getBelongNodeIp(),
                 "poolId": pool_id,
                 "newEsn": new_disk.getEsn(),
                 "oldEsn": old_disk.getEsn()}
            )


def add_ssd_cache_to_pool(rest_service, old_disk, new_disk, _type):
    if old_disk.getMediaType().toString() in SSD_TYPES:
        for pool_id in old_disk.getBelongPoolIds():
            rest_service.exec_post(
                "/dsware/service/cluster/storagepool/replaceSSDCache",
                {"nodeMgrIp": old_disk.getBelongNodeIp(),
                 "id": pool_id,
                 "newEsn": new_disk.getEsn(),
                 "oldEsn": old_disk.getEsn(),
                 "type": _type}
            )
