#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/08/18
@file: cluster_info_util.py
@function: 集群信息工具类
@modify:
"""

from py.fusion_cube.common.constant import ClusterRestUri

OCEANSTOR_PACIFIC = 'OceanStor Pacific'


def get_cluster_upgrade_status(service):
    dict_info = service.exec_get(ClusterRestUri.QUERY_UPGRADE_STATUS)
    return dict_info.get("data", {}).get("currentPhase", "")


def is_ocean_stor_pacific(context):
    product_model = context.getCluster().getStorageVersionInfo().getDeviceType().toString()
    return product_model == OCEANSTOR_PACIFIC


def is_zk_fault_exceed_limit(rest_service):
    """
    判断zk盘是否超冗余故障
    判断逻辑：只要zk盘超冗余故障了，整个zk集群就故障了，所有的角色就不会是follower或leader
    :param rest_service: rest服务
    :return: True/False 超冗余故障/未超冗余故障
    """
    res_dict = rest_service.exec_get(ClusterRestUri.QUERY_MANAGE_CLUSTER_INFO)
    for node in res_dict.get("nodeInfo", []):
        if node.get('zkRole') in ['follower', 'leader']:
            return False
    return True
