#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/07/15
@file: query_disk_info_util.py
@function:
@modify:
"""

from py.fusion_cube.common.constant import ClusterRestUri
from py.common.service.connection.cube_rest_connection_service import CubeRestService
from py.fusion_cube.common.context import disk_context_util

DISK_LIGHT_NOT_SUPPORT = 2
DISK_LIGHT_OPEN = 1
DISK_LIGHT_CLOSE = 0


def query_all_pool_ids(context):
    service = CubeRestService(context.getCluster())
    res_dict = service.exec_get(ClusterRestUri.QUERY_STORAGE_POOL_INFO)
    pool_ids = list()
    for pool_info in res_dict.get("storagePools", []):
        pool_ids.append(pool_info.get("poolId"))
    return pool_ids


def query_disk_drive_letter(context, disk_esn):
    service = CubeRestService(context.getCluster())
    res_dict = service.exec_get(ClusterRestUri.QUERY_ALL_INFO)
    belong_ip = disk_context_util.get_belong_mgmt_ip(context)
    for mgr_ip, disk_infos in res_dict.get("disks", {}).items():
        if mgr_ip != belong_ip:
            continue
        for info in disk_infos:
            if info.get("devEsn") == disk_esn:
                return "/dev/{}".format(info.get("devName"))
    # 元数据盘不在位查不出来
    return ""


def query_all_pool_node_mgr_ips(context):
    pool_ids = query_all_pool_ids(context)
    mgr_ip_list = list()
    for pool_id in pool_ids:
        mgr_ip_list.extend(_query_pool_node_mgr_ips(context, pool_id))
    return list(set(mgr_ip_list))


def query_pilot_disks_esn_list(context):
    """
    查询当前集群所有数据导航盘的esn列表
    :param context: 上下文
    :return: 数据导航盘esn列表
    """
    disks = list()
    res = CubeRestService(context.getCluster()).exec_get(ClusterRestUri.QUERY_DP_SERVICE_DISK)
    for node in res.get("nodes", []):
        for disk_info in node.get("disks"):
            disks.append(disk_info.get("esn"))
    return disks


def is_disk_support_light(context, node_ip, disk_esn):
    """
    指定硬盘是否支持点灯操作
    :param context: 上下文
    :param node_ip: 节点IP
    :param disk_esn: 硬盘ESN
    :return: True/False 支持/不支持
    """
    return _query_disk_light_status(
        context, node_ip, disk_esn) != DISK_LIGHT_NOT_SUPPORT


def _query_disk_light_status(context, node_ip, disk_esn):
    """
    查询硬盘点灯状态
    :param context: 上下文
    :param node_ip: 节点IP
    :param disk_esn: 硬盘ESN
    :return: 点灯状态：0-关闭 1-开启 2-不支持
    """
    service = CubeRestService(context.getCluster())
    res_dict = service.exec_post(ClusterRestUri.DISK_LIGHT_INQUIRY, params={
        "nodeIpList": [node_ip]
    })
    media_info_list = []
    for node_info in res_dict.get('nodeInfo', []):
        if node_info.get('nodeMgrIp') == node_ip:
            media_info_list = node_info.get('mediaInfo', [])
            break
    for media_info in media_info_list:
        if media_info.get('phyDevEsn') == disk_esn:
            return int(media_info.get('diskLightStatus'))
    return DISK_LIGHT_NOT_SUPPORT


def _query_pool_node_mgr_ips(context, pool_id):
    service = CubeRestService(context.getCluster())
    res_dict = service.exec_get(ClusterRestUri.QUERY_DISK_INFO,
                                params={"poolId": pool_id})
    mgr_ip_list = list()
    for node in res_dict.get("nodeInfo", []):
        mgr_ip_list.append(node.get('nodeMgrIp'))
    return mgr_ip_list
