#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/11/20
@file: disk_info_query_trans_dict.py
@function: 查盘接口的返回值和框架中BaseDisk的映射
@modify:
"""
from py.common.adapter import java_adapter
from py.common.service.java_device_filed_translator import \
    ValueFieldTranslator, EnumFieldTranslator, IntValueFieldTranslator
from py.fusion_cube.common import constant

MEDIA_TYPE_TRANS_DICT = {
    "sas_disk": "SAS_DISK",
    "sata_disk": "SATA_DISK",
    "ssd_card": "SSD_CARD",
    "ssd_disk": "SSD_DISK",
    "m2_disk": "M2_DISK",
    "unknown": "UNKNOWN"
}

DEV_ROLE_TRANS_DICT = {
    "zk_disk": "ZK_DISK",
    "main_storage": "MAIN_STORAGE",
    "osd_cache": "OSD_CACHE",
    "system_disk": "System_DISK",
    "no_use": "NO_USE"
}


def get_query_all_disk_trans_dict():
    """
    对应接口：/dsware/service/resource/queryAllDisk
    :return:
    """
    return {
        "devEsn": ValueFieldTranslator("setEsn"),
        "devSlot": IntValueFieldTranslator("setSlotNo"),
        "devType": EnumFieldTranslator("setMediaType",
                                       java_adapter.get_media_type_class(),
                                       MEDIA_TYPE_TRANS_DICT),
        "devRole": EnumFieldTranslator("setMediaRole",
                                       java_adapter.get_media_role_class(),
                                       DEV_ROLE_TRANS_DICT),
        "devTotalCapacity": ValueFieldTranslator("setCapacity"),
        "devTotalCapacityForByte": ValueFieldTranslator("setCapacityForByte"),
        "devStatus": ValueFieldTranslator("setStatus"),
        "sectorSize": ValueFieldTranslator("setSectorSize"),
        "logicSectorSize": ValueFieldTranslator("setLogicSectorSize"),
    }


def get_trans_dict_by_rest_uri(rest_uri):
    """
    根据URI，返回对应的映射字典
    :param rest_uri: uri
    :return: 映射字典
    """
    return uri_to_trans.get(rest_uri)()


uri_to_trans = {
    constant.ClusterRestUri.QUERY_ALL_INFO: get_query_all_disk_trans_dict
}
