#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/08/13
@file: disk_info_service.py
@function:
@modify:
"""

from py.common.adapter import java_adapter
from py.common.service.connection.cube_rest_connection_service import CubeRestService
from py.fusion_cube.common.constant import ClusterRestUri
from py.fusion_cube.common.service.disk_init_factory import \
    disk_info_query_trans_dict


class DiskInitService(object):
    def __init__(self, context):
        self._context = context
        self._rest_service = CubeRestService(context.getCluster())
        self._all_disks = self._query_all_disks_by_all_info_rest()

    def query_cur_module_disks(self):
        """
        查询当前类型的硬盘列表, 用于初始化
        :return:
        """
        raise NotImplementedError

    def query_node_disks(self, mgr_ip):
        """
        查询当前节点的所有盘列表, 用于更换流程中前后对比
        :return:
        """
        raise NotImplementedError

    @staticmethod
    def _translate_2_java_object(disk_info, origin_key_2_translator,
                                 node_mgr_ip, disk_exist=None):
        disk = java_adapter.get_disk_class()()
        disk.setBelongNodeIp(node_mgr_ip)
        if disk_exist is not None:
            disk.setDiskExist(disk_exist)
        for origin_key, translator in origin_key_2_translator.items():
            if disk_info.get(origin_key) is not None:
                translator.set_field(disk, disk_info.get(origin_key))
        return disk

    def _query_all_disks_by_all_info_rest(self):
        data = self._rest_service.exec_get(ClusterRestUri.QUERY_ALL_INFO)
        res = data.get("disks", {})
        disks = list()
        for mgr_ip, disk_info_list in res.items():
            for disk_info in disk_info_list:
                all_info_trans_dict = disk_info_query_trans_dict \
                    .get_trans_dict_by_rest_uri(ClusterRestUri.QUERY_ALL_INFO)
                disks.append(self._translate_2_java_object(
                    disk_info, all_info_trans_dict, mgr_ip))
        return disks

    def find_disk_by_esn(self, esn):
        for disk in self._all_disks:
            if disk.getEsn() == esn:
                return disk
        return None
