#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/11/20
@file: init_pilot_disk_info_service.py
@function: 数据导航盘查询服务
@modify:
"""
from py.common.adapter import java_adapter
from py.common.service.java_device_filed_translator import \
    ValueFieldTranslator, EnumFieldTranslator, IntValueFieldTranslator
from py.fusion_cube.common.constant import ClusterRestUri, DISK_NOT_EXIST, \
    DISK_EXIST
from py.fusion_cube.common.service.disk_init_factory.disk_info_query_trans_dict import \
    MEDIA_TYPE_TRANS_DICT
from py.fusion_cube.common.service.disk_init_factory.disk_info_service import \
    DiskInitService

PILOT_DISK_ROLE = "PILOT_DISK"
PILOT_NOT_EXIST_STATUS = 101


class InitPilotDiskInfoService(DiskInitService):
    @staticmethod
    def get_pilot_disk_trans_dict():
        return {
            "esn": ValueFieldTranslator("setEsn"),
            "slot": IntValueFieldTranslator("setSlotNo"),
            "media_type": EnumFieldTranslator("setMediaType",
                                              java_adapter.get_media_type_class(),
                                              MEDIA_TYPE_TRANS_DICT),
            "total_capacity": IntValueFieldTranslator("setCapacity"),
            "status": ValueFieldTranslator("setStatus"),
        }

    def query_node_disks(self, mgr_ip):
        return [disk for disk in self._all_disks
                if disk.getBelongNodeIp() == mgr_ip]

    def query_cur_module_disks(self):
        disks = list()
        res = self._rest_service.exec_get(ClusterRestUri.QUERY_DP_SERVICE_DISK)
        for node in res.get("nodes", []):
            manage_ip = node.get("manage_ip")
            for disk_info in node.get("disks"):
                disks.append(self._get_base_disk_from_disk_res(disk_info, manage_ip))
        self.fill_disks_info(disks)
        return disks

    def fill_disks_info(self, disks):
        for disk in disks:
            # 在位导航盘的其他信息（扇区/容量) 用query_all_info接口数据进行补充（统一单位且完善信息）
            if disk.getDiskExist() == DISK_EXIST:
                match_disk = self.find_disk_by_esn(disk.getEsn())
                if match_disk:
                    disk.setCapacity(match_disk.getCapacity())
                    disk.setSectorSize(match_disk.getSectorSize())
                    disk.setLogicSectorSize(match_disk.getLogicSectorSize())

    def _get_base_disk_from_disk_res(self, disk_res, node_mgr_ip):
        is_exist = DISK_NOT_EXIST if disk_res.get("status") == \
                                     PILOT_NOT_EXIST_STATUS else DISK_EXIST
        disk = self._translate_2_java_object(
            disk_res, self.get_pilot_disk_trans_dict(), node_mgr_ip, is_exist)
        trans_object = java_adapter.get_media_role_class().valueOf(
            PILOT_DISK_ROLE)
        getattr(disk, "setMediaRole")(trans_object)
        return disk
