#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/12/08
@file: operation_factory.py
@function: 对于需要bmc鉴权的接口进行隔离：如redfish
@modify:
"""
from py.common.service.connection.redfish_connection_service import RedfishService
from py.fusion_cube.common.service.hardware_operation_factory.redfish_util import RedfishUtil


class HardwareOperationFactory(object):
    def __init__(self, context):
        self._context = context
        self._redfish_service = RedfishService(context.getBmcNode())

    def get_match_init_service(self):
        return RedfishUtil(self._redfish_service)
