#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/12/08
@file: redfish_util.py
@function: 集成需要bmc鉴权的redfish方法
@modify:
"""
import time

from py.fusion_cube.common.service.bmc import chassis_resource_util
from py.fusion_cube.common.service.bmc.chassis_resource_util import power_off_device, is_device_power_on, \
    get_device_slot_id
from py.fusion_cube.common.service.hardware_operation_factory.operation_service import OperationService


class RedfishUtil(OperationService):
    def __init__(self, connection):
        self._redfish_service = connection

    def get_hard_raid_card_type(self):
        """
        查询当前硬盘的硬RAID卡类型
        :return: RAID卡类型
        """
        # 先通过RAIDCard信息获取RAID卡类型
        raid_type = chassis_resource_util.get_raid_type_by_raid_card(self._redfish_service)
        if raid_type:
            return raid_type
        # 上面步骤未能获取到RAID卡类型，尝试从PCIE信息中获取
        raid_type = chassis_resource_util.get_raid_type_by_pcie(self._redfish_service)
        if raid_type:
            return raid_type
        # 通过PCIE拓展信息获取
        raid_type = chassis_resource_util.get_raid_type_by_pcie_extend(self._redfish_service)
        if raid_type:
            return raid_type
        return ""

    def power_off_device(self):
        """
        设备下电
        :return: 下电结果：是/否，错误信息
        """
        return power_off_device(self._redfish_service)

    def is_device_power_on(self, start_time, time_out, interval=10):
        """
        获取设备电源状态
        :return: 电源状态，错误信息
        """

        slot_id = get_device_slot_id(self._redfish_service)
        while True:
            if time.time() - start_time > time_out:
                return False
            if not is_device_power_on(self._redfish_service, slot_id):
                time.sleep(interval)
                continue
            return True
