#  coding=UTF-8
#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/07/16
@file: storage_pool_status_service.py
@function:
@modify:
"""

from py.common.service import logger_factory, resource_service
from py.fusion_cube.common.constant import ClusterRestUri

POOL_STATUS_REFACTORING = 8
POOL_STATUS_NORMAL = 0
# 降级
POOL_STATUS_DEGRADED = 7

POOL_STATUS_NAME_DICT = {
    POOL_STATUS_REFACTORING: resource_service.get_msg('pool.status.refactoring.name'),
    POOL_STATUS_NORMAL: resource_service.get_msg('pool.status.normal.name'),
    POOL_STATUS_DEGRADED: resource_service.get_msg('pool.status.degraded.name')
}


def get_pool_status_name(pool_status_list):
    return ','.join([POOL_STATUS_NAME_DICT.get(pool_status, "")
                     for pool_status in pool_status_list])


def check_storage_pool_is_target(connection_service, pool_ids, target_status_list):
    logger = logger_factory.create_logger(__file__)
    pool_id_2_status = _get_pool_2_status(connection_service, pool_ids)
    target_pool_ids = _get_target_pool_ids(pool_id_2_status, target_status_list)
    not_queried_pool_ids = _get_not_queried_pool_ids(
        pool_ids, pool_id_2_status.keys())
    logger.info(
        "pool_id_2_status: {}, target_pool_ids: {}, not_queried_pool_ids: {}".format(
            pool_id_2_status, target_pool_ids, not_queried_pool_ids))
    return target_pool_ids, not_queried_pool_ids


def _get_pool_2_status(service, pool_ids):
    pool_id_2_status = dict()
    res_dict = service.exec_get(
        ClusterRestUri.QUERY_STORAGE_POOL_INFO)
    for pool in res_dict.get("storagePools", []):
        pool_id = pool.get("poolId")
        if pool_id in pool_ids:
            pool_id_2_status[pool_id] = pool.get("poolStatus")
        if len(pool_id_2_status) == len(pool_ids):
            return pool_id_2_status
    return pool_id_2_status


def _get_target_pool_ids(pool_id_2_status, target_status_list):
    abnormal_pool_ids = list()
    for pool_id, status in pool_id_2_status.items():
        if status in target_status_list:
            abnormal_pool_ids.append(pool_id)
    return abnormal_pool_ids


def _get_not_queried_pool_ids(disk_pool_ids, queried_status_pool_ids):
    not_queried_pool_ids = list()
    for pool_id in disk_pool_ids:
        if pool_id not in queried_status_pool_ids:
            not_queried_pool_ids.append(pool_id)
    return not_queried_pool_ids
