#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/07/16
@file: add_cache_disk_to_storage_pool.py
@function:
@modify:
"""
from py.common.adapter import java_adapter
from py.common.service.auto_brush_item_progress import auto_brush_progress
from py.fusion_cube.common.service import add_disk_to_pool_service
from py.common.service.connection.cube_rest_connection_service import CubeRestService
from py.fusion_cube.common.service import disk_out_storage_pool_service
from py.fusion_cube.common.record import record_cache_disk_replace_type
from py.fusion_cube.common.record import record_cache_disk_match_main_disk
from py.common.entity.exception import ConnectionException
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service


@auto_brush_progress(300)
def execute(context):
    old_disk = context.getData()
    new_disk = context.getDataAfterReplace()
    rest_service = CubeRestService(context.getCluster())
    try:
        if record_cache_disk_replace_type.is_online_replace_type(context):
            # 在线缓存盘 设置随路时钟 对nvme盘进行上下电
            result = tuple(java_adapter.get_nvme_disk_restart_service().restartNvmeDisk(context))
            if result[0] == ItemStatus.FAILED:
                return result
            add_disk_to_pool_service.add_ssd_cache_to_pool(
                rest_service, old_disk, new_disk, "online")
        else:
            _handle_offline_replace_disk(context, new_disk, old_disk,
                                         rest_service)
        return ItemStatus.SUCCESS, ""
    except ConnectionException as ex:
        return ItemStatus.FAILED, resource_service.get_msg(
            "cache.add.storage.pool.failed").format(
            CubeRestService.get_description(ex.response))


def _handle_offline_replace_disk(context, new_disk, old_disk, rest_service):
    # 如果缓存盘没有对应主存盘，走updateSSDCacheESN
    if not record_cache_disk_match_main_disk.get_recorded_cache_disk_match_main_disks(
            context):
        add_disk_to_pool_service.update_ssd_cache_esn(
            rest_service, old_disk, new_disk)
        return
    out_pool_main_disks = disk_out_storage_pool_service.get_out_pool_cache_match_main_disk(
        context)
    # 有对应主存盘需要被加入存储池
    if out_pool_main_disks:
        add_disk_to_pool_service.update_ssd_cache_esn(
            rest_service, old_disk, new_disk)
    else:
        add_disk_to_pool_service.force_add_ssd_card_to_pool(
            rest_service,
            old_disk,
            new_disk,
            "cache",
            ignore_media_fault="true"
        )
