#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/05/31
@file: disk_health_status_check.py
@function: 更换后检查硬盘健康状态
@modify:
"""
import time

from py.fusion_cube.common.context import disk_context_util
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service
from py.common.service.auto_brush_item_progress import auto_brush_progress
from py.fusion_cube.common.service.disk_init_factory.init_service_factory \
    import DiskInitServiceFactory
from py.fusion_cube.common.context import common_context_util
from py.fusion_cube.common.service import disk_check_util


@auto_brush_progress(180)
def execute(context):
    status, msg = DiskHealthStatusCheckItem(context, 180, 10).check()
    if ItemStatus.PASS != status and disk_context_util.is_pilot_module(context):
        if disk_check_util.need_power_off(context):
            common_context_util.set_cur_task_suggestion(context, resource_service
                                                        .get_msg('need.power.off.pilot.disk.suggestion'))
        else:
            common_context_util.set_cur_task_suggestion(context, resource_service.get_msg('pilot.disk.suggestion'))
    return status, msg


def _disk_is_health(disk_status):
    return disk_status == 0


class DiskHealthStatusCheckItem(object):

    def __init__(self, context, wait_time, query_interval_time):
        if query_interval_time <= 0:
            raise ValueError
        self.replace_disk_sn = disk_context_util.get_replace_disk_sn(context)
        self.context = context
        self.wait_time = wait_time
        self.query_interval_time = query_interval_time

    def check(self):
        """
        定时轮询看盘状态是否正常
        """
        wait_time = 0
        while wait_time < self.wait_time:
            disk_infos = DiskInitServiceFactory(self.context) \
                .get_match_init_service().query_cur_module_disks()
            if self.contains_health_replace_disk(disk_infos):
                return ItemStatus.PASS, ""
            time.sleep(self.query_interval_time)
            wait_time += self.query_interval_time
        return ItemStatus.NOT_PASS, resource_service.get_msg(
            "disk.status.abnormal")

    def contains_health_replace_disk(self, disk_infos):
        if disk_context_util.is_pilot_module(self.context) or \
                disk_context_util.is_meta_module(self.context):
            return _disk_is_health(disk_context_util.get_data_after_replace_status(self.context))
        for info in disk_infos:
            if self.replace_disk_sn == info.getEsn() and _disk_is_health(info.getStatus()):
                return True
        return False
