#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/08/18
@file: check_node_upgrade_status.py
@function: 更换前检查集群，是否存在升级类任务
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service
from py.common.service.connection.cube_rest_connection_service import CubeRestService
from py.fusion_cube.common.service.cluster.cluster_info_util \
    import get_cluster_upgrade_status


def execute(context):
    """
    检查节点升级状态
    """
    service = CubeRestService(context.getCluster())
    upgrade_status = get_cluster_upgrade_status(service)
    # 只有currentPhase是""，才是没有升级任务，其他都是有
    if upgrade_status:
        return ItemStatus.NOT_PASS, resource_service.get_msg(
            "node.in.upgrade")
    return ItemStatus.PASS, ""
