#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2022/1/4
@file: check_pilot_sync_complete.py
@function: 检查数据导航盘是否同步完成
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service
from py.common.service.connection.ssh_connection_service import SshService, Cmd
from py.fusion_cube.common.context import common_context_util

QUERY_PILOT_SYNC_CMD = "sh /opt/dfv/obs_service_layer/objectwebservice" \
                       "/elasticsearch/script/elasticsearch_tool.sh health"
SYNC_COMPLETE_STATUS = "green"


def execute(context):
    if _is_pilot_sync_complete(context):
        return ItemStatus.PASS, ""
    common_context_util.set_cur_task_suggestion(
        context, resource_service.get_msg('check.pilot.sync.complete.suggestion'))
    return ItemStatus.NOT_PASS, resource_service.get_msg(
        'check.pilot.sync.complete.failed.cause')


def _is_pilot_sync_complete(context):
    ssh_conn = SshService(context.getNode())
    res = ssh_conn.exec_cmd(Cmd(QUERY_PILOT_SYNC_CMD))
    lines = res.splitlines()
    for line in lines:
        if '"status"' in line:
            return SYNC_COMPLETE_STATUS in line
    return False
