#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/05/25
@file: check_pool_status.py
@function: 更换前检查更换盘所属存储池状态
@modify:
"""
from py.common.service.connection.cube_rest_connection_service import CubeRestService
from py.fusion_cube.common.context import disk_context_util
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service
from py.fusion_cube.common.context.common_context_util import \
    set_cur_task_suggestion
from py.fusion_cube.common.service.storage_pool_status_service import \
    check_storage_pool_is_target, POOL_STATUS_REFACTORING, \
    POOL_STATUS_NORMAL, POOL_STATUS_DEGRADED, get_pool_status_name
from py.fusion_cube.common.service.disk_out_storage_pool_service import \
    get_storage_pool_ids
from py.fusion_cube.common.record import record_cache_disk_replace_type
from py.fusion_cube.common.service.cluster.cluster_info_util \
    import is_ocean_stor_pacific


def execute(context):
    """
    检查存储池状态
    810之后，必须为正常或降级
    """
    service = CubeRestService(context.getCluster())
    storage_pool_ids = get_storage_pool_ids(context, service)
    normal_status_list = [POOL_STATUS_NORMAL]
    # 健康主存盘要求存储池状态正常
    if disk_context_util.is_health_main_disk(context):
        return check_is_abnormal(context, service,
                                 storage_pool_ids, normal_status_list)
    # 非健康主存盘 810后 要求为正常或降级
    if is_ocean_stor_pacific(context):
        normal_status_list.append(POOL_STATUS_DEGRADED)
        return check_is_abnormal(context, service,
                                 storage_pool_ids, normal_status_list)
    # 非健康主存盘 810前 为不能为重构
    return check_is_refactoring(context, service, storage_pool_ids)


def check_is_refactoring(context, service, pool_ids):
    refactoring_pool_ids, not_queried_pool_ids = check_storage_pool_is_target(
        service, pool_ids, [POOL_STATUS_REFACTORING])
    err_msgs = list()
    if not_queried_pool_ids:
        err_msgs.append(resource_service.get_msg(
            "not.queried.pool.status").format(str(not_queried_pool_ids)))
    if refactoring_pool_ids:
        set_cur_task_suggestion(
            context,
            resource_service.get_msg(
                'check.pool.status.failed.refactoring.suggestion'))
        err_msgs.append(resource_service.get_msg(
            "pool.status.refactoring").format(str(refactoring_pool_ids)))
    if err_msgs:
        return ItemStatus.NOT_PASS, "\n".join(err_msgs)
    return ItemStatus.PASS, ""


def check_is_abnormal(context, service, pool_ids, normal_status_list):
    normal_pool_ids, not_queried_pool_ids = check_storage_pool_is_target(
        service, pool_ids, normal_status_list)
    err_msgs = list()
    if not_queried_pool_ids:
        err_msgs.append(resource_service.get_msg(
            "not.queried.pool.status").format(str(not_queried_pool_ids)))
    abnormal_pool_ids = list()
    for pool_id in pool_ids:
        if pool_id not in normal_pool_ids \
                and pool_id not in not_queried_pool_ids:
            abnormal_pool_ids.append(pool_id)
    if abnormal_pool_ids:
        set_cur_task_suggestion(
            context,
            resource_service.get_msg(
                'check.pool.status.failed.abnormal.suggestion').format(
                get_pool_status_name(normal_status_list)))
        err_msgs.append(resource_service.get_msg(
            "pool.status.abnormal").format(str(abnormal_pool_ids)))
    if err_msgs:
        return ItemStatus.NOT_PASS, "\n".join(err_msgs)
    return ItemStatus.PASS, ""


def execute_in_replace_cache(context):
    """
    检查存储池状态
    1.在线更换必须为正常
    2.离线更换，810之后，必须为正常或降级，其他只需要非重构
    """
    service = CubeRestService(context.getCluster())
    storage_pool_ids = get_storage_pool_ids(context, service)
    normal_status_list = [POOL_STATUS_NORMAL]
    if record_cache_disk_replace_type.is_online_replace_type(context):
        return check_is_abnormal(context, service,
                                 storage_pool_ids, normal_status_list)
    if is_ocean_stor_pacific(context):
        normal_status_list.append(POOL_STATUS_DEGRADED)
        return check_is_abnormal(context, service,
                                 storage_pool_ids, normal_status_list)
    return check_is_refactoring(context, service, storage_pool_ids)
