#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/11/25
@file: check_raid_card_status.py
@function: 检查RAID卡状态
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service
from py.fusion_cube.common.constant import RaidStatus
from py.fusion_cube.common.context import common_context_util
from py.fusion_cube.common.record import record_raid_card_type
from py.common.service import logger_factory
from py.fusion_cube.common.service.os_util.raid_card_util import get_raid_card


def execute(context):
    if common_context_util.is_proprietary_hardware(context):
        return ItemStatus.NOT_INVOLVED, ""
    logger = logger_factory.create_logger(__file__)
    logger.info("start to check raid card status")
    raid_card_type = record_raid_card_type.get_raid_card_type(context)
    if not raid_card_type:
        return ItemStatus.NOT_INVOLVED, ""
    raid_card = get_raid_card(context, raid_card_type, logger)
    if not raid_card:
        return ItemStatus.NOT_PASS, resource_service.get_msg("check.raid.not.supported.type.suggestion")
    raid_status, cmd = raid_card.check_raid_card_status()
    if raid_status == RaidStatus.ACTIVE:
        return ItemStatus.PASS, ""
    if raid_status == RaidStatus.REBUILDING:
        standard = raid_card.get_post_check_status_standard()
        suggestion = resource_service.get_msg('check.raid.card.status.suggestion').format(cmd, standard)
        common_context_util.set_cur_task_suggestion(context, suggestion)
        return ItemStatus.NOT_PASS, resource_service.get_msg("check.raid.status.rebuild.suggestion")
    common_context_util.set_cur_task_suggestion(context, resource_service
                                                .get_msg('check.raid.status.not.in.progress.suggestion'))
    return ItemStatus.NOT_PASS, resource_service.get_msg("check.raid.status.not.in.progress")
