#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.
"""
@version: SmartKit V200R007C00
@time: 2021/07/08
@file: finish.py
@function:
@modify:
"""
import time

from py.fusion_cube.common import constant
from py.fusion_cube.common.context import disk_context_util
from py.common.entity.item_status import ItemStatus
from py.fusion_cube.common.service.disk_init_factory.init_service_factory import \
    DiskInitServiceFactory


def execute(context):
    set_replace_disk_info(context)
    # 规避加入后闪断的问题，重试
    if not disk_context_util.is_replace_disk_exist(context):
        time.sleep(5)
        set_replace_disk_info(context)
    # 更换缓存盘时需要选择对应待加入存储池的主存盘，此时需要刷新主存盘信息
    if disk_context_util.is_cache_module(context):
        pool_service = DiskInitServiceFactory(context).get_pool_init_service()
        context.initModuleDataByModuleId(
            constant.Module.MAIN_DISK,
            pool_service.query_assign_module_disks(constant.Module.MAIN_DISK))
    return ItemStatus.SUCCESS, ""


def set_replace_disk_info(context):
    new_disk_sn = disk_context_util.get_replace_disk_sn(context)
    new_disks = DiskInitServiceFactory(context) \
        .get_match_init_service().query_cur_module_disks()
    for disk in new_disks:
        if disk.getEsn() == new_disk_sn:
            context.setDataAfterReplace(disk)
            return


def set_replace_cascade_info(context):
    # 当前信息已更新至替换后信息中
    return ItemStatus.SUCCESS, ""


def set_replace_ar_card_info(context):
    # 更换后AR卡信息已经在查询更换信息步骤中，这里就不做任何操作了
    return ItemStatus.SUCCESS, ""
