#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/06/07
@file: init_fru_info.py
@function: 初始化更换前信息，主要用于记录更换前的信息，用于更换后进行与更换后的信息
进行比较
@modify:
"""
from py.common.entity.exception import BusinessException
from py.common.service.auto_brush_item_progress import auto_brush_progress
from py.fusion_cube.common.record import record_sg_device_info, \
    record_cache_disk_match_main_disk, record_nvme_ssd_form, \
    record_cache_disk_replace_type, record_node_disk_info, \
    record_main_disk_out_pool, record_meta_usage_mode, \
    record_disk_manufacturer, record_sys_disk_fault_type, record_raid_card_type
from py.common.entity.item_status import ItemStatus

MODULE_2_record_items = {
    "mainDisk": [record_sg_device_info, record_nvme_ssd_form,
                 record_node_disk_info, record_main_disk_out_pool,
                 record_disk_manufacturer],
    "cacheDisk": [record_nvme_ssd_form, record_cache_disk_match_main_disk,
                  record_cache_disk_replace_type, record_node_disk_info,
                  record_disk_manufacturer],
    "metaDisk": [record_sg_device_info, record_nvme_ssd_form,
                 record_node_disk_info, record_meta_usage_mode,
                 record_disk_manufacturer],
    "pilotDisk": [record_node_disk_info, record_nvme_ssd_form,
                  record_disk_manufacturer],
    "sysDisk": [record_node_disk_info, record_disk_manufacturer, record_sys_disk_fault_type, record_raid_card_type]
}


@auto_brush_progress(60)
def execute(context):
    try:
        record_items = MODULE_2_record_items.get(context.getModuleId())
        for item in record_items:
            item.record(context)
        return ItemStatus.SUCCESS, ""
    except BusinessException as ex:
        return ItemStatus.FAILED, ex.err_msg
