#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/11/29
@file: power_off_device.py
@function: 下电节点
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service
from py.common.service.auto_brush_item_progress import auto_brush_progress
from py.fusion_cube.common.context import common_context_util
from py.fusion_cube.common.service.hardware_operation_factory.operation_factory import HardwareOperationFactory


@auto_brush_progress(180)
def execute(context):
    if not common_context_util.is_proprietary_hardware(context):
        return ItemStatus.NOT_INVOLVED, ""
    service = HardwareOperationFactory(context).get_match_init_service()
    if service.power_off_device():
        return ItemStatus.SUCCESS, ""
    return ItemStatus.FAILED, resource_service.get_msg("power.off.device.failed")
