#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/05/31
@file: pre_process_disk.py
@function: 硬盘预处理，踢出存储池或者逻辑下电
@modify:
"""
import time

from py.common.entity.exception import BusinessException
from py.common.service import resource_service
from py.common.service.auto_brush_item_progress import auto_brush_progress
from py.common.service.connection.cube_rest_connection_service import CubeRestService
from py.common.service.connection.ssh_connection_service import SshService
from py.fusion_cube.common.context import disk_context_util
from py.common.entity.item_status import ItemStatus
from py.fusion_cube.common.constant import ClusterRestUri
from py.fusion_cube.common.record import record_main_disk_out_pool
from py.fusion_cube.common.service import disk_out_storage_pool_service
from py.fusion_cube.common.service import disk_check_util


@auto_brush_progress(60)
def execute(context):
    # 健康主存盘需要先踢盘
    try:
        if disk_context_util.is_health_main_disk(context):
            _out_health_main_disk(context)
            # 等待10s等待踢盘完成
            time.sleep(10)
            record_main_disk_out_pool.record(context)
            if not record_main_disk_out_pool.is_main_disk_out_pool(context):
                return ItemStatus.FAILED, \
                       resource_service.get_msg("out.disk.failed").format(
                           disk_context_util.get_disk_sn(context))
    except BusinessException as ex:
        return ItemStatus.FAILED, ex.err_msg

    if disk_check_util.need_power_off(context):
        _power_off(context)

    if not disk_context_util.is_health_main_disk(
            context) and not disk_check_util.need_power_off(context):
        return ItemStatus.NOT_INVOLVED, ""
    return ItemStatus.SUCCESS, ""


def _power_off(context):
    service = CubeRestService(context.getCluster())
    service.exec_post(ClusterRestUri.DISK_POWER_OFF, {
        "nodeMgrIp": disk_context_util.get_belong_mgmt_ip(context),
        "slotNo": disk_context_util.get_disk_slot(context),
        "esn": disk_context_util.get_disk_sn(context),
        "powerType": "power_off"
    })


def _out_health_main_disk(context):
    for pool_id in disk_context_util.get_disk_belong_pool_ids(context):
        disk_out_storage_pool_service.out_disk_to_pool(
            SshService(context.getNode()),
            [disk_context_util.get_disk_sn(context)], pool_id, context)
