#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/08/06
@file: recover_control_cluster_ccdb.py
@function: 恢复控制集群的ccdb
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service.auto_brush_item_progress import auto_brush_progress
from py.common.service.connection.ssh_connection_service import SshService
from py.fusion_cube.common.record import record_meta_usage_mode
from py.fusion_cube.common.service.recover_cluster_ccdb_service import \
    AbstractRecoverClusterCCDBService
from py.fusion_cube.common.service.cluster.cluster_info_util \
    import is_ocean_stor_pacific

CONTROL_CONFIG_DIR_PATH = \
    "/opt/dsware/client/conf/service/eds/serviceMediaConfig.xml"
CONTROL_CLUSTER_REPLACE_DISK_CMD = \
    'sh /opt/dsware/client/bin/dswareTool.sh --op ReplaceMediaDisk -controlClusterId {} -processType ccdb_server ' \
    '-processId {} -nodeIps {}'
CONTROL_CLUSTER_ID_QUERY_CMD = "cat /opt/dsware/infrastructure/ccdb/ccdb_server/config/ccdb_server.cfg | " \
                               "grep dr_cluster_id |awk -F \"=\" {'print $2'}"
CONTROL_CLUSTRR_PROCESS_ID_QUERY_CMD = "cat /opt/dsware/infrastructure/ccdb/ccdb_server/config/ccdb_server.cfg | " \
                                       "grep local_ip |awk -F \"=|:\" {'print $2'}"


@auto_brush_progress(60)
def execute(context):
    # 复制集群独立使用时不涉及
    if not record_meta_usage_mode.is_replication_use_alone(context):
        return RecoverControlClusterCCDB(context).recover_ccdb()
    return ItemStatus.NOT_INVOLVED, ""


class RecoverControlClusterCCDB(AbstractRecoverClusterCCDBService):
    def __init__(self, context):
        super(RecoverControlClusterCCDB, self).__init__(context)
        self._ssh_service = SshService(context.getNode())

    def _get_query_cluster_id_cmd(self):
        return CONTROL_CLUSTER_ID_QUERY_CMD

    def _get_query_ccdb_server_process_id_cmd(self):
        return CONTROL_CLUSTRR_PROCESS_ID_QUERY_CMD

    def _get_replace_disk_cmd(self):
        return CONTROL_CLUSTER_REPLACE_DISK_CMD

    def _get_remote_conf_dir_path(self):
        return CONTROL_CONFIG_DIR_PATH

    def _is_need_y(self):
        return is_ocean_stor_pacific(self._context)
