#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/08/06
@file: recover_replication_cluster_ccdb.py
@function: 恢复复制集群的ccdb
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service.auto_brush_item_progress import auto_brush_progress
from py.fusion_cube.common.record import record_meta_usage_mode
from py.fusion_cube.common.service.recover_cluster_ccdb_service import \
    AbstractRecoverClusterCCDBService

REPLICATION_CONFIG_DIR_PATH = \
    "/opt/dsware/client/conf/service/dr/serviceMediaConfig.xml"
REPLICATION_CLUSTER_REPLACE_DISK_CMD = 'sh /opt/dsware/client/bin/dswareTool.sh --op drCmd -subOp ReplaceMediaDisk ' \
                                       '-controlClusterId {} -processId {} -processType ccdb_server -nodeIps {}'
REPLICATION_CLUSTER_ID_QUERY_CMD = "cat /opt/dsware/service/dr/ccdb_server/config/ccdb_server.cfg | grep " \
                                   "dr_cluster_id |awk -F \"=\" {'print $2'} "
REPLICATION_CCDB_SERVER_PROCESS_ID_QUERY_CMD = "cat /opt/dsware/service/dr/ccdb_server/config/ccdb_server.cfg " \
                                               "| grep local_ip |awk -F \"=|:\" {'print $2'}"


@auto_brush_progress(60)
def execute(context):
    # 控制集群独立使用时为不涉及
    if not record_meta_usage_mode.is_control_use_alone(context):
        return RecoverReplicationClusterCCDB(context).recover_ccdb()
    return ItemStatus.NOT_INVOLVED, ""


class RecoverReplicationClusterCCDB(AbstractRecoverClusterCCDBService):
    MONTH_LIST = []

    def __init__(self, context):
        super(RecoverReplicationClusterCCDB, self).__init__(context)

    def _get_query_cluster_id_cmd(self):
        return REPLICATION_CLUSTER_ID_QUERY_CMD

    def _get_query_ccdb_server_process_id_cmd(self):
        return REPLICATION_CCDB_SERVER_PROCESS_ID_QUERY_CMD

    def _get_replace_disk_cmd(self):
        return REPLICATION_CLUSTER_REPLACE_DISK_CMD

    def _get_remote_conf_dir_path(self):
        return REPLICATION_CONFIG_DIR_PATH

    def _is_need_y(self):
        return False
