#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/11/21
@file: update_data_pilot_esn_in_db.py
@function: 更新备用硬盘模块的存储表（数据导航盘）
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service
from py.common.service.auto_brush_item_progress import auto_brush_progress
from py.common.service.connection.ssh_connection_service import SshService, \
    COMMON_SSH_ENDING, CustomEndingJudgeCmd
from py.fusion_cube.common.context import disk_context_util, \
    common_context_util


@auto_brush_progress(60)
def execute(context):
    mgr_ip = disk_context_util.get_belong_mgmt_ip(context)
    old_disk_esn = disk_context_util.get_disk_sn(context)
    new_disk_esn = disk_context_util.get_replace_disk_sn(context)
    cmd = "sh /opt/dsware/manager/script/datapilot_update_esn.sh " \
          "update_esn_in_db " \
          "{} {} {}".format(mgr_ip, old_disk_esn, new_disk_esn)
    ssh_conn = SshService(common_context_util.get_active_fsm_node(context))
    res = ssh_conn.exec_cmd(CustomEndingJudgeCmd(cmd, COMMON_SSH_ENDING))
    if "enter y to continue:" in res:
        res = ssh_conn.exec_cmd(CustomEndingJudgeCmd('y', COMMON_SSH_ENDING))
    if "success" not in res.lower():
        return ItemStatus.FAILED, \
               resource_service.get_msg('update.data.pilot.esn.in.db.failed')
    return ItemStatus.SUCCESS, ""
