#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2023. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/06/01
@file: constant.py
@function:
@modify:
"""

DISK_EXIST = 0
DISK_NOT_EXIST = 1
NODE_SYS_DISKS = "NODE_SYS_DISKS"


class ClusterRestUri(object):
    QUERY_ALL_INFO = "/dsware/service/resource/queryAllDisk"
    QUERY_STORAGE_POOL_INFO = "/dsware/service/resource/queryStoragePool"
    QUERY_DISK_POOL_INFO = "/api/v2/data_service/diskpool"
    DISK_POWER_OFF = "/dsware/service/server/poweroffNvmeDisk"
    QUERY_DISK_INFO = "/dsware/service/cluster/storagepool/queryNodeDiskInfo"
    QUERY_STORAGE_POOL = "/dsware/service/cluster/storagepool/queryStoragePool"
    QUERY_DISK_POOL = "/api/v2/data_service/diskpool"
    QUERY_UPGRADE_STATUS = "/api/v2/upgrade/upgrade_status"
    QUERY_FAIL_OVER_STATUS = "/dsware/service/fail_over/checkfailoverstatus"
    SET_CACHE_DISK_RW_STATUS = "/dsware/service/fail_over/setCacheDiskRwStatus"
    QUERY_TASK_URL = "/dsware/service/task/queryTaskInfo"
    SMART_CACHE_INFO = "/api/v2/data_service/cache_perf"
    QUERY_SERVER_MODEL = "/dsware/service/cluster/storagepool/queryServerStorageMode"
    SET_SERVER_MODEL = "/dsware/service/cluster/storagepool/setServerStorageMode"
    RESTORE_SUBHEALTH_NODE = "/dsware/service/cluster/restoreSubhealthNode"
    CHANGE_DISK_LIGHT = "/dsware/service/v1.3/disk/light/led_control"
    QUERY_MANAGE_CLUSTER_INFO = '/dsware/service/cluster/queryManageCluster'
    DSWARE_SERVER_CMD = "/dsware/service/serviceCmd"
    BATCH_QUERY_ALARMS = "/api/v2/common/alarms"
    BATCH_CLEAN_ALARMS = "/dsware/service/v1.3/alarm/clean"
    DISK_LIGHT_INQUIRY = "/dsware/service/v1.3/disk/light/inquiry"
    QUERY_DP_SERVICE_DISK = "/api/v2/cluster_service/dp_service"
    SCAN_SYSTEM_MEDIA = "/dsware/service/vsan/scanServerSystemMedia"
    CHANGE_IO_CHECK_SWITCH = "/dsware/service/cluster/modifyAgentNodeConfig"


class Module(object):
    MAIN_DISK = "mainDisk"
    CACHE_DISK = "cacheDisk"
    META_DISK = "metaDisk"
    PILOT_DISK = "pilotDisk"
    SYS_DISK = "sysDisk"

    # 更换场景和盘角色的对应关系，对应更换场景只需获取到对应角色的盘即可
    MODULE_2_disk_type = {
        MAIN_DISK: ["MAIN_STORAGE"],
        CACHE_DISK: ["OSD_CACHE"],
        META_DISK: ["ZK_DISK"]
    }


class RaidStatus(object):
    ACTIVE = "active"
    REBUILDING = "rebuilding"
    UNKNOWN = "unknown"


class RaidCardType(object):
    SAS3108 = "3108"
    SAS3416 = "3416"
    SAS3408 = "3408"
    SAS3508 = "3508"
    SAS3152 = "3152"
    SAS3908 = "3908"
    RAID1880I16 = "SP686C"
    RAID1880I8 = "SP186"


class DiskStatus(object):
    HEALTH = 0
    FAULT = 1
    REBUILDING = 10
