#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2024. All rights reserved.

"""
@version: SmartKit 22.0.0
@time: 2022/09/17
@file: record_check_pool_type.py
@function: 用于记录/控制检查池的状态时检查的是存储池还是硬盘池, 与产品保持一致(8.1.3之后检查硬盘池)
@modify:
"""
from py.common.adapter import java_adapter
from py.fusion_storage.common.context import disk_context_util
from py.fusion_storage.common.service.cluster import cluster_info_util
from py.fusion_storage.common.service.disk_out_storage_pool_service import get_storage_pool_ids

CHECK_TYPE_KEY = 'CHECK_POOL_TYPE'
CHECK_POOL_TYPE_DISK = 'DISK_POOL'
CHECK_POOL_TYPE_STOR = 'STORAGE_POOL'


def record(context):
    context.getEnv()[CHECK_TYPE_KEY] = CHECK_POOL_TYPE_DISK \
        if _is_check_disk_pool_status(context) else CHECK_POOL_TYPE_STOR


def get_pool_check_type(context):
    return context.getEnv()[CHECK_TYPE_KEY]


def is_check_disk_pool(context):
    return get_pool_check_type(context) == CHECK_POOL_TYPE_DISK


def _is_check_disk_pool_status(context):
    product_version = context.getFruDevice().getBusinessDevice().getDevNode().getProductVersion()
    if cluster_info_util.is_a310_product(context) or cluster_info_util.is_dataturbo_product(context):
        return True
    if "RC" in product_version:
        return java_adapter.compare_version(product_version, '8.1.RC6') >= 0
    return java_adapter.compare_version(product_version, "8.1.3") >= 0


def get_check_pool_ids(context, service):
    """
    获取需要检查的池的ID列表，当前场景列表中只有一个元素
    :param context: 上下文
    :param service: 连接
    :return: 池ID列表
    """
    if is_check_disk_pool(context):
        return disk_context_util.get_disk_belong_pool_ids(context)
    return get_storage_pool_ids(context, service)
