#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

"""
@version: SmartKit 23.0.0
@time: 2023/07/19
@file: record_disk_takeover_status.py
@function:
@modify:
"""
from py.common.service.connection import ssh_cmd_util
from py.fusion_storage.common.context import disk_context_util
from py.common.service.connection.ssh_connection_service import SshService, Cmd

NODE_DISKS = "NODE_DISKS"
OLD_DISK_INFOS = "OLD_DISK_INFOS"


def record(context):
    # 记录硬盘是否被接管的信息，如果是更换缓存盘场景，需要保存更换前节点的show_disk.sh信息
    disk_info = context.getData()
    if not disk_info:
        return
    ssh_service = SshService(context.getNode())
    vnode_id = disk_context_util.get_disk_vnode_id(context)
    if disk_context_util.is_main_module(context):
        disk_info.setTakeOver(check_disk_in_take_over_status(ssh_service, vnode_id))
    if disk_context_util.is_cache_module(context):
        cmd = ssh_cmd_util.get_show_disk_infos_cmd(ssh_service.is_mini_system)
        context.getEnv()[OLD_DISK_INFOS] = ssh_service.exec_cmd(Cmd(cmd))


def check_disk_in_take_over_status(service, vnode_id):
    # 倒换的单元是级联板，如果级联板Id对应存在盘被接管，则该级联板所有的主存盘都被接管
    check_takeover_cmd = ssh_cmd_util.get_check_disk_takeover_status_cmd(service.is_mini_system)
    takeover_vnode_id_set = set()
    for info in service.exec_cmd(Cmd(check_takeover_cmd)).splitlines():
        info_list = info.strip().split()
        if len(info_list) != 3:
            continue
        if info_list[2] != "normal":
            takeover_vnode_id_set.add(info_list[1])
    return vnode_id in takeover_vnode_id_set
