#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2023. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/12/04
@file: record_raid_card_type.py
@function:
@modify:
"""
from py.fusion_storage.common.context import common_context_util
from py.fusion_storage.common.service.hardware_operation_factory.operation_factory import HardwareOperationFactory

HAS_HARD_RAID_CARD = "has_hard_raid_card"
RAID_CARD_TYPE = "raid_card_type"


def record(context):
    if common_context_util.is_two_oceans_hardware(context):
        context.getEnv()[HAS_HARD_RAID_CARD] = False
        return
    service = HardwareOperationFactory(context).get_match_init_service()
    raid_card_type = service.get_hard_raid_card_type()
    if not raid_card_type:
        context.getEnv()[HAS_HARD_RAID_CARD] = False
        return
    context.getEnv()[HAS_HARD_RAID_CARD] = True
    context.getEnv()[RAID_CARD_TYPE] = raid_card_type


def _has_hard_raid_card(context):
    return context.getEnv().get(HAS_HARD_RAID_CARD)


def get_raid_card_type(context):
    """
    获取硬RAID卡类型，如果返回空表示没有硬RAID卡
    """
    if _has_hard_raid_card(context):
        return context.getEnv().get(RAID_CARD_TYPE)
    return ""
