#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/07/13
@file: record_sg_device_info.py
@function: 记录lsscsi -g命令信息，用于更换后检查作比较
@modify:
"""
from py.common.service.connection.ssh_connection_service import SshService
from py.fusion_storage.common.service.cluster import query_disk_info_service
from py.fusion_storage.common.service.os_util import hardware_info_util
from py.fusion_storage.common.context import disk_context_util

DISK_DRIVE_LETTER = "disk_drive_letter"
SG_DEVICE_INFOS = "sg_device_infos"


def record(context):
    """
    执行入口
    :param context: 执行上下文
    :return: 是否成功， 失败错误信息
    """
    # nvme盘不涉及
    if disk_context_util.is_nvme_disk(context):
        return
    old_disk_drive_letter = \
        query_disk_info_service.query_disk_drive_letter(
            context, disk_context_util.get_disk_sn(context))
    context.getEnv()[DISK_DRIVE_LETTER] = old_disk_drive_letter
    sg_device_infos = hardware_info_util.get_sg_device_infos(SshService(
        context.getNode()))
    context.getEnv()[SG_DEVICE_INFOS] = sg_device_infos


def get_recorded_sg_device_infos(context):
    """
    获取缓存的sg_device_infos
    :param context: 业务上下文
    :return: 缓存的sg_device_infos，list(list, list..)，
    每行为一个info，一个info中包含多个field
    """
    return context.getEnv().get(SG_DEVICE_INFOS)


def get_recorded_disk_drive_letter(context):
    """
    获取记录的硬盘盘符
    :param context: 业务上下文
    :return: 盘符str。例如sdb
    """
    return context.getEnv().get(DISK_DRIVE_LETTER)
