#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/12/22
@file: disk_out_storage_pool.py
@function: 封装一些可共用的硬盘信息判断方法
@modify:
"""
from py.fusion_storage.common.context import common_context_util
from py.fusion_storage.common.record import record_nvme_ssd_form


def need_power_off(context):
    # 两大洋服务器不需要逻辑下电
    if common_context_util.is_proprietary_hardware(context):
        return False
    # 海光服务器NVMe盘不需要逻辑下电
    if common_context_util.is_hg_server(context):
        return False
    return record_nvme_ssd_form.get_nvme_ssd_form(
        context) == record_nvme_ssd_form.NvmeSsdForm.DISK
