#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2023. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/08/13
@file: init_pool_disk_info_service.py
@function: 存储池中得盘的查询服务, 包括主存盘和缓存盘
@modify:
"""
from py.common.adapter import java_adapter
from py.common.service.java_device_filed_translator import \
    ValueFieldTranslator, EnumFieldTranslator, ListFieldTranslator, IntValueFieldTranslator, StringValueFieldTranslator
from py.fusion_storage.common.constant import Module, ClusterRestUri
from py.fusion_storage.common.service.cluster import query_disk_info_service
from py.fusion_storage.common.service.disk_init_factory.disk_info_query_trans_dict import \
    MEDIA_TYPE_TRANS_DICT, DEV_ROLE_TRANS_DICT
from py.fusion_storage.common.service.disk_init_factory.disk_info_service import \
    DiskInitService


class InitPoolDiskInfoService(DiskInitService):
    @staticmethod
    def query_node_info_trans_dict():
        return {
            "diskSn": ValueFieldTranslator("setEsn"),
            "diskSlot": IntValueFieldTranslator("setSlotNo"),
            "slotDesc": ValueFieldTranslator("setSlotDesc"),
            "diskType": EnumFieldTranslator("setMediaType",
                                            java_adapter.get_media_type_class(),
                                            MEDIA_TYPE_TRANS_DICT),
            "diskRole": EnumFieldTranslator("setMediaRole",
                                            java_adapter.get_media_role_class(),
                                            DEV_ROLE_TRANS_DICT),
            "diskSize": ValueFieldTranslator("setCapacity"),
            "diskStatus": ValueFieldTranslator("setStatus"),
            "diskExist": ValueFieldTranslator("setDiskExist"),
            "pools": ListFieldTranslator("setBelongPoolIds", list_key="poolId"),
            "sectorSize": ValueFieldTranslator("setSectorSize"),
            "logicSectorSize": ValueFieldTranslator("setLogicSectorSize"),
            "virtualDisk": ValueFieldTranslator("setVirtualDisk"),
            "vNodeId": StringValueFieldTranslator("setBelongVnodeId")
        }

    def query_cur_module_disks(self):
        return self.query_assign_module_disks(self._context.getModuleId())

    def query_node_disks(self, mgr_ip):
        disks = self.query_all_disks()
        node_disks = list()
        for disk in disks:
            # diskType(mediaType)为"none时", 为无用信息, 需过滤
            if disk.getBelongNodeIp() == mgr_ip \
                    and disk.getMediaType() is not None:
                node_disks.append(disk)
        return node_disks

    def query_disk_by_esn(self, esn):
        disks = self.query_all_disks()
        for disk in disks:
            if disk.getEsn() == esn:
                return disk
        return None

    def query_all_disks(self):
        pool_ids = query_disk_info_service.query_all_pool_ids(self._context)
        all_disk = list()
        for pool_id in pool_ids:
            all_disk.extend(self._query_pool_disks(pool_id))
        return all_disk

    def query_disks_in_storage_pools(self, pool_ids):
        all_disk = list()
        for pool_id in pool_ids:
            all_disk.extend(self._query_pool_disks(pool_id))
        return all_disk

    def _query_pool_disks(self, pool_id):
        origin_key_2_translator = self.query_node_info_trans_dict()
        res_dict = self._rest_service.exec_get(
            ClusterRestUri.QUERY_DISK_INFO,
            params={"poolId": pool_id})
        disks = list()
        for node_info in res_dict.get("nodeInfo", []):
            ip = node_info.get("nodeMgrIp")
            for disk_info in self._get_media_info(node_info):
                disks.append(self._translate_2_java_object(
                    disk_info, origin_key_2_translator, ip))
        return disks

    def _get_media_info(self, node_info):
        media_info = node_info.get("mediaInfo", [])
        if not media_info:
            return []
        return media_info

    def query_pool_node_main_disks(self, pool_ids, mgmt_ip):
        disks = list()
        for pool_id in pool_ids:
            disks.extend(self._query_pool_disks(pool_id))
        node_main_disks = list()
        for disk in disks:
            if disk.getBelongNodeIp() == mgmt_ip and \
                    disk.getMediaRole().toString() == "MAIN_STORAGE":
                node_main_disks.append(disk)
        return node_main_disks

    def query_assign_module_disks(self, module_id):
        """
        查询指定模块硬盘
        :param module_id: 模块ID
        :return:
        """
        involve_disk_type = Module.MODULE_2_disk_type.get(module_id)
        all_disks = self.query_all_disks()
        module_all_disks = list()
        for disk in all_disks:
            if disk.getMediaRole().toString() in involve_disk_type:
                module_all_disks.append(disk)
        return module_all_disks
