#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/08/13
@file: init_service_factory.py
@function: factory: 根据当前模块选择合适初始化实现
@modify:
"""
from py.fusion_storage.common.constant import Module
from py.fusion_storage.common.service.disk_init_factory\
    .init_meta_disk_info_service import InitMetaDiskInfoService
from py.fusion_storage.common.service.disk_init_factory.init_pilot_disk_info_service import \
    InitPilotDiskInfoService
from py.fusion_storage.common.service.disk_init_factory\
    .init_pool_disk_info_service import InitPoolDiskInfoService
from py.fusion_storage.common.service.disk_init_factory.init_sys_disk_info_service import \
    InitSysDiskInfoService

INIT_SERVICE_DICT = {
    Module.MAIN_DISK: InitPoolDiskInfoService,
    Module.CACHE_DISK: InitPoolDiskInfoService,
    Module.META_DISK: InitMetaDiskInfoService,
    Module.PILOT_DISK: InitPilotDiskInfoService,
    Module.SYS_DISK: InitSysDiskInfoService
}


class DiskInitServiceFactory(object):
    def __init__(self, context):
        self._context = context

    def get_match_init_service(self):
        match_service = INIT_SERVICE_DICT.get(self._context.getModuleId())
        return match_service(self._context)

    def get_pool_init_service(self):
        return InitPoolDiskInfoService(self._context)

    def get_sys_init_service(self):
        return InitSysDiskInfoService(self._context)
