#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/06/09
@file: hardware_info_util.py
@function:
@modify:
"""
import re
from py.common.service.connection.ssh_connection_service import Cmd
SPLIT_LINE_FIELD_REG = re.compile(r"\s+")


def get_sg_device_infos(connection):
    """
    获取os系统中sg设备信息
    :param connection: 连接
    :return: list(list, list..)，每行为一个info，一个info中包含多个field
    """
    origin_info = connection.exec_cmd(Cmd("lsscsi -g"))
    infos = list()
    for line in origin_info.splitlines():
        infos.append(SPLIT_LINE_FIELD_REG.split(line))
    return infos
