#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/07/18
@file: mdc_info_util.py
@function:
@modify:
"""
from py.common.service.connection.ssh_connection_service import Cmd
from py.common.service import ssh_info_handle_util


def get_mdc_cmd_181_infos(ssh_service):
    origin_info = ssh_service.exec_cmd(Cmd("mdc_cmd.sh 181"))
    info_lines = origin_info.splitlines()
    title_index = 0
    for index, line in enumerate(info_lines):
        if "MDC NID" in line:
            title_index = index
            break
    return ssh_info_handle_util.parse_horizontal_table_by_chars("\n".join(
        info_lines[title_index:]), "|")


def is_pure_3_replica(ssh_service, pool_id):
    strategy_keys = ("p_user_input_protect_mode", "p_protect_mode")
    for key in strategy_keys:
        info = ssh_service.exec_cmd(
            Cmd("mdc_cmd.sh 172 {} | grep {}".format(pool_id, key)))
        if not info.split("|")[-2].strip() == "replica":
            return False
    return True
