#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2024. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/07/16
@file: add_cache_disk_to_storage_pool.py
@function:
@modify:
"""
from py.common.service.auto_brush_item_progress import auto_brush_progress
from py.common.service.connection import ssh_cmd_util
from py.common.service.connection.ssh_connection_service import SshService, NoNeedReturnCmd, KeepAliveCmd
from py.fusion_storage.common.context import disk_context_util
from py.fusion_storage.common.service import add_disk_to_pool_service
from py.common.service.connection.rest_connection_service import RestService
from py.fusion_storage.common.service import disk_out_storage_pool_service
from py.fusion_storage.common.record import record_cache_disk_replace_type
from py.fusion_storage.common.record import record_cache_disk_match_main_disk
from py.common.entity.exception import ConnectionException
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service


@auto_brush_progress(300)
def execute(context):
    if disk_context_util.is_virtual_disk(context):
        result, err_msg = _add_sriov_disk_to_pool(context)
        return result, err_msg
    old_disk = context.getData()
    new_disk = context.getDataAfterReplace()
    rest_service = RestService(context.getCluster())
    try:
        if record_cache_disk_replace_type.is_online_replace_type(context):
            add_disk_to_pool_service.add_ssd_cache_to_pool(
                rest_service, old_disk, new_disk, "online")
        else:
            _handle_offline_replace_disk(context, new_disk, old_disk,
                                         rest_service)
        return ItemStatus.SUCCESS, ""
    except ConnectionException as e:
        return ItemStatus.FAILED, resource_service.get_msg(
            "cache.add.storage.pool.failed").format(
            RestService.get_description(e.response))


def _handle_offline_replace_disk(context, new_disk, old_disk, rest_service):
    # 如果缓存盘没有对应主存盘，走updateSSDCacheESN
    if not record_cache_disk_match_main_disk.get_recorded_cache_disk_match_main_disks(
            context):
        add_disk_to_pool_service.update_ssd_cache_esn(
            rest_service, old_disk, new_disk)
        return
    out_pool_main_disks = disk_out_storage_pool_service.get_out_pool_cache_match_main_disk(
        context)
    # 有对应主存盘需要被加入存储池
    if out_pool_main_disks:
        add_disk_to_pool_service.update_ssd_cache_esn(
            rest_service, old_disk, new_disk)
    else:
        add_disk_to_pool_service.force_add_ssd_card_to_pool(
            rest_service,
            old_disk,
            new_disk,
            "cache",
            ignore_media_fault="true"
        )


def _add_sriov_disk_to_pool(context):
    # sriov虚拟盘通过sh指令将盘加入存储池
    connection = SshService(context.getDswareNode())
    mgmt_ip = disk_context_util.get_belong_mgmt_ip(context)
    old_disk = context.getData()
    new_disk = context.getDataAfterReplace()
    for pool_id in old_disk.getBelongPoolIds():
        cmd_list = ssh_cmd_util.get_replace_sriov_cache_cmd(connection.is_mini_system,
                                                            connection.is_sandbox_open,
                                                            context.getDswareNode())
        cmd_list[-1] = NoNeedReturnCmd(cmd_list[-1].format(pool_id, old_disk.getEsn(), new_disk.getEsn(), mgmt_ip))
        cmd_list.extend(
            [
                NoNeedReturnCmd("y"),
                NoNeedReturnCmd(context.getCluster().getLoginUser().getUserName()),
                KeepAliveCmd(context.getCluster().getLoginUser().getPassword(), 1800, is_need_log=False)
            ]
        )
        if connection.is_sandbox_open:
            res = connection.exec_dsware_cmd_with_sandbox_open(cmd_list)
        else:
            res = connection.exec_dsware_cmd(cmd_list)
        if "failed" in res:
            return ItemStatus.FAILED, resource_service.get_msg("cache.add.storage.pool.failed").format(res)
        return ItemStatus.SUCCESS, ""
