#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

"""
@version: SmartKit 22.0.3
@time: 2023/07/22
@file: change_cache_disk_rw_status.py
@function: 设置/取消缓存盘只读状态
@modify:
"""
from py.common.adapter import java_adapter
from py.common.adapter.java_adapter import get_task_name_class, get_query_task_process
from py.common.entity.exception import ConnectionException
from py.common.entity.item_status import ItemStatus
from py.common.service.auto_brush_item_progress import auto_brush_progress
from py.common.service.connection.rest_connection_service import RestService
from py.fusion_storage.common.constant import ClusterRestUri
from py.common.service import resource_service
from py.fusion_storage.common.context import common_context_util, disk_context_util
from py.fusion_storage.module.disk.item.change_node_fail_over_status import NodeFailOverService

READ_ONLY_STATUS = 0
WRITABLE_STATUS = 1
RW_TASK_NAME_ZH = "设置缓存盘读写状态"
RW_TASK_NAME_EN = "Set Cache Disk RW Status"


@auto_brush_progress(180)
def set_cache_disk_readonly(context):
    rw_status_service = NodeRwStatusService(context)
    if not rw_status_service.is_east_sea_and_vnode_ec():
        return ItemStatus.NOT_INVOLVED, ""
    if rw_status_service.set_cache_disk_rw_status(READ_ONLY_STATUS) and rw_status_service.check_task_process():
        return ItemStatus.SUCCESS, ""
    return ItemStatus.FAILED, resource_service.get_msg('cache.disk.set.readonly.failed')


@auto_brush_progress(180)
def set_cache_disk_writable(context):
    rw_status_service = NodeRwStatusService(context)
    if not rw_status_service.is_east_sea_and_vnode_ec():
        return ItemStatus.NOT_INVOLVED, ""
    if rw_status_service.set_cache_disk_rw_status(WRITABLE_STATUS):
        return ItemStatus.SUCCESS, ""
    return ItemStatus.FAILED, resource_service.get_msg('cache.disk.set.writable.failed')


class NodeRwStatusService:
    def __init__(self, context):
        self._disk_infos = context.getEnv().getOrDefault("NODE_DISKS", [])
        self._context = context
        self._cluster = context.getCluster()
        self._manage_ip = disk_context_util.get_belong_mgmt_ip(context)

    def is_east_sea_and_vnode_ec(self):
        return NodeFailOverService(self._context).check_is_vnode_ec_pool() \
               and common_context_util.is_east_sea_server(self._context)

    def set_cache_disk_rw_status(self, status):
        try:
            service = RestService(self._cluster)
            param = {"faultMgrIp": self._manage_ip, "status": status}
            response = service.exec_post(ClusterRestUri.SET_CACHE_DISK_RW_STATUS, param)
            return response.get("result") == 0
        except ConnectionException as e:
            return False

    def check_task_process(self):
        try:
            task_name = get_task_name_class()(RW_TASK_NAME_ZH, RW_TASK_NAME_EN)
            return get_query_task_process().queryTaskProcessByName(self._cluster, task_name)
        except java_adapter.get_java_exception_class() as e:
            return False
