#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/11/25
@file: change_node_status.py
@function: 上线/下线节点
@modify:
"""
import time

from py.common.entity.exception import ConnectionException
from py.common.entity.item_status import ItemStatus
from py.common.service.auto_brush_item_progress import auto_brush_progress
from py.common.service.connection.rest_connection_service import RestService
from py.fusion_storage.common.context import disk_context_util, common_context_util
from py.common.service import resource_service, logger_factory

# 查询离线/上线节点超时时间 30分钟
QUERY_TASK_TIMEOUT = 30 * 60
# 默认重试间隔
DEFAULT_INTERVAL = 10


@auto_brush_progress(180)
def start_service(context):
    logger = logger_factory.create_logger(__file__)
    manage_ip = disk_context_util.get_belong_mgmt_ip(context)
    params = dict(start_service=manage_ip)
    return change_service_status(context, params, "start", logger)


@auto_brush_progress(180)
def stop_service(context):
    logger = logger_factory.create_logger(__file__)
    manage_ip = disk_context_util.get_belong_mgmt_ip(context)
    params = dict(stop_service=manage_ip)
    try:
        return change_service_status(context, params, "stop", logger)
    except ConnectionException:
        return ItemStatus.FAILED, resource_service.get_msg('stop.service.failed')


def change_service_status(context, params, task_type, logger):
    def change_status():
        url = "/api/v2/cluster/cluster_node"
        service = RestService(context.getCluster())
        res_dict = service.exec_post(url, params)
        if "data" not in res_dict.keys():
            logger.error("The returned result does not meet the expectation.Changing the service status may fail.")
            return ""
        return res_dict.get("data").get("task_id")

    if not common_context_util.is_proprietary_hardware_with_soft_raid(context):
        return ItemStatus.NOT_INVOLVED, ""
    task_id = change_status()
    flag, err_msg = query_task_status(context, task_id, task_type)
    if not flag:
        return ItemStatus.FAILED, err_msg
    return ItemStatus.SUCCESS, ""


def query_task_status(context, task_id, task_type):
    query_uri = "/api/v2/cluster/sub_tasks?sub_task_id=1&task_id={}".format(task_id)

    start_time = time.time()
    while time.time() - start_time < QUERY_TASK_TIMEOUT:
        service = RestService(context.getCluster())
        res_dict = service.exec_get(query_uri)
        if "data" not in res_dict.keys():
            continue
        server_detail = res_dict.get("data").get("server_detail")
        server_task_status = server_detail[0].get("server_task_status")
        if server_task_status == "success":
            return True, ""
        if server_task_status == "failure":
            return False, resource_service.get_msg("{}.service.failed".format(task_type))
        time.sleep(DEFAULT_INTERVAL)
    return False, resource_service.get_msg("{}.service.timeout".format(task_type))
