#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.

"""
@version: SmartKit 23.0.0.3
@time: 2023/11/14
@file: change_sys_disk_io_check_switch.py
@function: 开启/关闭系统盘IO检测开关
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service
from py.common.service.auto_brush_item_progress import auto_brush_progress
from py.common.service.connection.rest_connection_service import RestService
from py.fusion_storage.common.constant import ClusterRestUri
from py.fusion_storage.common.context import disk_context_util
from py.fusion_storage.common.service.cluster import cluster_info_util

BLOCK_LIST = ["8.1.5", "8.1.RC7", "8.2.0", "8.1.6", "8.2.1"]
OPEN_STATUS = "1"
CLOSE_STATUS = "0"


@auto_brush_progress(180)
def open_io_check_switch(context):
    sys_io_switch_service = ChangeSysDiskIoSwitchService(context)
    if not sys_io_switch_service.need_change_io_switch():
        return ItemStatus.NOT_INVOLVED, ""
    if sys_io_switch_service.io_check_switch(OPEN_STATUS):
        return ItemStatus.SUCCESS, ""
    return ItemStatus.FAILED, resource_service.get_msg('open.sys.disk.io.check.switch.failed')


@auto_brush_progress(180)
def close_io_check_switch(context):
    sys_io_switch_service = ChangeSysDiskIoSwitchService(context)
    if not sys_io_switch_service.need_change_io_switch():
        return ItemStatus.NOT_INVOLVED, ""
    if sys_io_switch_service.io_check_switch(CLOSE_STATUS):
        return ItemStatus.SUCCESS, ""
    return ItemStatus.FAILED, resource_service.get_msg('close.sys.disk.io.check.switch.failed')


class ChangeSysDiskIoSwitchService:
    def __init__(self, context):
        self._context = context
        self._cluster = context.getCluster()
        self._manage_ip = disk_context_util.get_belong_mgmt_ip(context)
        self._product_version = context.getFruDevice().getBusinessDevice().getDevNode().getProductVersion()

    def io_check_switch(self, mode):
        service = RestService(self._cluster)
        result = service.exec_post(ClusterRestUri.CHANGE_IO_CHECK_SWITCH,
                                   {"parameterList": [{"paramName": "sys_disk_io_check_switch", "paramValue": mode}],
                                    "nodeIp": self._manage_ip})
        return result.get("result", -1) == 0

    def need_change_io_switch(self):
        # 8.1.5以后需要开关io检测
        return any(block_version in self._product_version for block_version in BLOCK_LIST) or \
               cluster_info_util.is_a310_product(self._context)
