#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

"""
@version: SmartKit 24.0.0
@time: 2024/12/11
@file: check_component_temperature.py
@function: 更换硬盘备件前对部件温度进行检查
"""
from py.common.service import logger_factory, resource_service
from py.common.service.auto_brush_item_progress import auto_brush_progress
from py.common.service.connection import ssh_cmd_util
from py.common.service.connection.ssh_connection_service import SshService, KeepAliveCmd
from py.common.entity.item_status import ItemStatus
from py.fusion_storage.common.context import common_context_util

# 检查温度进度条显示时间暂定6分钟，因为等待部件降温需要5分钟，查询时间预留1分钟
TIMEOUT_S = 360
# 单次SSH命令超时时间暂定8分钟，因为等待部件降温需要5分钟，给命令查询和重试再预留3分钟
SSH_TIMEOUT_S = 480


class CheckComponentTemp(object):
    def __init__(self, context):
        self._context = context
        self._logger = logger_factory.create_logger(__file__)
        self._ssh_service = SshService(context.getNode())


    def _is_command_exist(self):
        cmd_str = ssh_cmd_util.get_temp_check_cmd(self._ssh_service.is_mini_system, "-h")
        cmd = KeepAliveCmd(cmd_str, SSH_TIMEOUT_S)
        ret = self._ssh_service.exec_cmd(cmd, retry_times=3)
        return "pangea_temp_check.sh start" in ret


    def check_comp_temp(self):
        if not self._is_command_exist():
            return ItemStatus.NOT_INVOLVED, ""
        cmd_str = ssh_cmd_util.get_temp_check_cmd(self._ssh_service.is_mini_system, "start")
        cmd = KeepAliveCmd(cmd_str, SSH_TIMEOUT_S)
        ret = self._ssh_service.exec_cmd(cmd, retry_times=1)
        if "Temperature check completed, you can proceed with replacing the spare parts." in ret:
            return ItemStatus.SUCCESS, ""
        elif "Device overheating, please contact Huawei engineer for technical support." in ret:
            return ItemStatus.FAILED, resource_service.get_msg("decrease.temp.failed")
        else:
            self._logger.error("Check component temperature failed.")
            return ItemStatus.FAILED, resource_service.get_msg("check.temp.failed")


@auto_brush_progress(TIMEOUT_S)
def check_comp_temp(context):
    # 仅太平洋硬件有此策略
    if not common_context_util.is_pacific_server(context):
        return ItemStatus.NOT_INVOLVED, ""
    return CheckComponentTemp(context).check_comp_temp()
