#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

"""
@version: SmartKit 23.0.0
@time: 2023/07/19
@file: check_disk_takeover_status.py
@function: 更换前检查，硬盘是否被对控接管
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service
from py.fusion_storage.common.context import disk_context_util
from py.fusion_storage.module.disk.item.change_node_fail_over_status import NodeFailOverService


def execute(context):
    """
    检查硬盘是否被对控接管
    """
    if not NodeFailOverService(context).check_is_vnode_ec_pool():
        return ItemStatus.NOT_INVOLVED, ""
    if disk_context_util.get_disk_takeover_status(context):
        return ItemStatus.NOT_PASS, resource_service.get_msg("disk.in.takeover")
    return ItemStatus.PASS, ""
