#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/07/18
@file: check_need_out_match_main_disk.py
@function:
@modify:
"""
from py.common.service.connection.ssh_connection_service import SshService
from py.common.entity.item_status import ItemStatus
from py.fusion_storage.common.service.os_util import mdc_info_util
from py.fusion_storage.common.service.os_util import disk_info_util
from py.fusion_storage.common.context import disk_context_util
from py.fusion_storage.common.record.record_cache_disk_match_main_disk import \
    get_recorded_cache_disk_match_main_disks
from py.fusion_storage.common.record import record_cache_disk_replace_type
from py.common.service import resource_service

INVOLVE_PRODUCT_VERSIONS = (
    "8.0.1", "8.0.1.SPH8", "8.0.1.SPH301", "8.0.1.SPH302", "8.0.1.SPH303",
    "8.0.1.SPH9", "8.0.1.SPH10", "8.0.1.SPH11", "8.0.1.SPH12", "8.0.1.SPH13")


def execute(context):
    if record_cache_disk_replace_type.is_online_replace_type(context) \
            or not is_involved_version(context):
        return ItemStatus.NOT_INVOLVED, ""
    service = SshService(context.getNode())
    pool_ids = disk_context_util.get_disk_belong_pool_ids(context)
    match_main_disk_sns = [disk.getEsn() for disk in
                           get_recorded_cache_disk_match_main_disks(context)]
    need_manual_out_disk_sns = list()
    for pool_id in pool_ids:
        if not mdc_info_util.is_pure_3_replica(service, pool_id):
            continue
        infos = disk_info_util.get_mdc_cmd_101_infos(service, pool_id)
        all_main_disk_sns = [info.get("OSD ESN") for info in infos]
        for sn in match_main_disk_sns:
            if sn in all_main_disk_sns:
                need_manual_out_disk_sns.append(sn)

    if need_manual_out_disk_sns:
        return ItemStatus.NOT_PASS, resource_service.get_msg(
            "manual.out.main.disk").format(str(need_manual_out_disk_sns))
    else:
        return ItemStatus.PASS, ""


def is_involved_version(context):
    product_version = context.getFruDevice().getBusinessDevice().getDevNode().getProductVersion()
    return product_version in INVOLVE_PRODUCT_VERSIONS
