#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

"""
@version: SmartKit 22.0.2
@time: 2023/04/24
@file: check_node_failover_status.py
@function: 更换前检查集群，待更换节点是否处于倒换状态
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service
from py.fusion_storage.module.disk.item.change_node_fail_over_status import NodeFailOverService


def execute(context):
    """
    检查节点倒换状态
    """
    result = NodeFailOverService(context).check_node_in_fail_over_status()
    if "NOT_INVOLVED" == result:
        return ItemStatus.NOT_INVOLVED, ""
    elif "True" == result:
        return ItemStatus.NOT_PASS, resource_service.get_msg("node.in.failover")
    return ItemStatus.PASS, ""
