#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

"""
@version: SmartKit 22.0.2
@time: 2023/05/26
@file: check_product_version.py
@function: 检查产品型号，812部分型号不支持更换缓存盘
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service

BLACK_LIST = ("8.1.2", "8.1.2.SPH003", "8.1.2.SPH002", "8.1.2.SPH001", "8.1.2.SPC100")


def execute(context):
    """
    检查产品型号，812部分型号不支持更换缓存盘
    """
    product_version = context.getFruDevice().getBusinessDevice().getDevNode().getProductVersionToShow()
    if product_version in BLACK_LIST:
        return ItemStatus.NOT_PASS, resource_service.get_msg("product.version.not.support").format(product_version)
    return ItemStatus.PASS, ""
