#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/11/25
@file: check_raid_card_level.py
@function: 检查RAID卡型号
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service import logger_factory, resource_service
from py.common.service.connection.ssh_connection_service import SshService
from py.fusion_storage.common.record import record_raid_card_type
from py.fusion_storage.common.service.os_util.raid_card_util import has_soft_raid1, get_raid_card


def execute(context):
    logger = logger_factory.create_logger(__file__)
    logger.info("start to check raid card level")
    raid_card_type = record_raid_card_type.get_raid_card_type(context)
    # 查询不到硬RAID型号时，查看是否有软RAID
    if not raid_card_type:
        ssh_service = SshService(context.getNode())
        if has_soft_raid1(ssh_service):
            return ItemStatus.PASS, ""
        return ItemStatus.NOT_PASS, resource_service.get_msg("check.not.raid1.suggestion")
    raid_card = get_raid_card(context, raid_card_type, logger)
    if not raid_card:
        return ItemStatus.NOT_PASS, resource_service.get_msg("check.raid.not.supported.type.suggestion")
    if raid_card.has_raid1():
        return ItemStatus.PASS, ""
    return ItemStatus.NOT_PASS, resource_service.get_msg("check.not.raid1.suggestion")
