#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2022/01/06
@file: check_raid_is_synchronizing.py
@function: 换盘前检查查看raid是否是在重构状态
@modify:
"""
from py.fusion_storage.common.service.disk_select_factory.system_disk_selector_factory import \
    SystemDiskSelectorFactory, handle_res_func
from py.common.entity.item_status import ItemStatus
from py.common.service.connection.ssh_connection_service import SshService
from py.common.service import logger_factory
from py.fusion_storage.common.service.os_util.raid_card_util import get_raid_card
from py.fusion_storage.common.service.raid_option_util import raid_sync_complete_check_util
from py.common.service import resource_service
from py.fusion_storage.common.record import record_raid_card_type
from py.fusion_storage.common.context import common_context_util


def execute(context):
    return RaidIsSynchronizing(context).check()


class RaidIsSynchronizing(object):
    def __init__(self, context):
        self._context = context
        self._partitioned_disk = None
        self._not_partition_disk = list()
        self._ssh = SshService(context.getNode())
        self._logger = logger_factory.create_logger(__file__)
        self._selector = SystemDiskSelectorFactory(context, self._ssh, self._logger, is_pre_check=True)

    def check(self):
        # 检查硬RAID是否重构中
        self._logger.info("start check raid card status")
        raid_card_type = record_raid_card_type.get_raid_card_type(self._context)
        if raid_card_type:
            raid_card = get_raid_card(self._context, raid_card_type, self._logger)
            flag, cmds = raid_card.is_raid_card_rebuilding()
            if flag:
                judgements = raid_card.get_post_check_status_standard()
                self._set_suggestion(resource_service.get_msg('wait.raid.card.reconstruction.complete').format(
                    raid_sync_complete_check_util.get_cmd_show_string(cmds), judgements))

                return ItemStatus.NOT_PASS, resource_service.get_msg('sync.not.complete')
            return ItemStatus.PASS, ""

        # 检查软RAID是否重构中
        partitioned_disk, not_partition_disk, disk_info = self._selector.find_disk_detail()
        self._logger.info('partitioned disk:{}'.format(partitioned_disk))
        if len(partitioned_disk) < 1:
            return ItemStatus.NOT_PASS, resource_service.get_msg('partitioned.disk.detail.error')
        # raid名称是一致的，两个盘只取一个用于获取raid名称拼接执行命令
        cmds = raid_sync_complete_check_util.get_raid_sync_query_cmds([partitioned_disk[0]])
        self._logger.info('start check soft raid,cmds: {}'.format(cmds))
        self._context.getEnv().put(self._context.getNode().getIp() + '_check_raid_cmds', cmds)
        if raid_sync_complete_check_util.RaidSyncStatus.REBUILDING != \
                raid_sync_complete_check_util.get_raid_sync_status(cmds, self._ssh, self._logger, handle_res_func):
            return ItemStatus.PASS, ''
        self._set_suggestion(resource_service.get_msg('wait.raid.sync.complete').format(
            raid_sync_complete_check_util.get_cmd_show_string(cmds),
            resource_service.get_msg('raid.sync.complete.judgements')))
        return ItemStatus.NOT_PASS, resource_service.get_msg('sync.not.complete')

    def _set_suggestion(self, suggestion):
        common_context_util.set_cur_task_suggestion(self._context, suggestion)
