#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2022/01/06
@file: check_raid_sync_complete.py
@function: 换盘后检查raid重构是否完成
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service.connection.ssh_connection_service import SshService
from py.common.service import logger_factory
from py.fusion_storage.common.record import record_raid_card_type
from py.fusion_storage.common.service.raid_option_util import raid_sync_complete_check_util
from py.fusion_storage.common.service.disk_select_factory.system_disk_selector_factory import handle_res_func
from py.common.service import resource_service
from py.fusion_storage.common.context import common_context_util


def execute(context):
    # 硬RAID卡不涉及
    if record_raid_card_type.get_raid_card_type(context):
        return ItemStatus.NOT_INVOLVED, ""
    logger = logger_factory.create_logger(__file__)
    ssh = SshService(context.getNode())
    cmd_list = context.getEnv().get(context.getNode().getIp() + '_check_raid_cmds')
    if raid_sync_complete_check_util.RaidSyncStatus.ACTIVATE == \
            raid_sync_complete_check_util.get_raid_sync_status(cmd_list, ssh, logger, handle_res_func):
        return ItemStatus.PASS, ''
    common_context_util.set_cur_task_suggestion(context, resource_service.get_msg('check.raid.sync.complete.suggestion')
                                                .format(raid_sync_complete_check_util.get_cmd_show_string(cmd_list),
                                                        resource_service.get_msg('raid.sync.complete.judgements')))
    return ItemStatus.NOT_PASS, resource_service.get_msg('sync.not.complete')
