#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/08/18
@file: check_replace_priority.py
@function: 检查更换优先级，多盘故障，更换有顺序要求
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service
from py.common.service.connection.rest_connection_service import RestService
from py.common.service.connection.ssh_connection_service import SshService
from py.fusion_storage.common.context import disk_context_util
from py.fusion_storage.common.service.disk_init_factory.init_service_factory import \
    DiskInitServiceFactory
from py.fusion_storage.common.service.disk_out_storage_pool_service import \
    get_storage_pool_ids
from py.fusion_storage.common.service.os_util import disk_info_util

# -1不在位，0健康，1故障，2亚健康， 7故障或已停止
# 如果是缓存是-1，对应主存肯定无法更换；
# 如果是1，大概率不能更换；如果是2，有可能不能更换；7已经基本停用，大概率不能更换
NEED_REPLACE_CACHE_DISK_STATUS = [-1, 1, 2, 7]


def execute(context):
    """
    主存盘，升级顺序检查：如果对应缓存盘故障，需要先升级缓存

    盘是否在存储池中，若未加入过，通过
    查询对应存储池下所有盘信息，是否存在需要优先更换的缓存盘
    如果没有，通过

    通过mdc 101命令，查询此主存对应的缓存，如果找得到就是只判断对应缓存的状态
    如果找不到对应关系，就判断此节点所有缓存状态
    不通过，“存储池内存在故障或亚健康缓存盘，更换主存盘存在风险，请先处理缓存盘。”
    """

    storage_pool_ids = get_storage_pool_ids(context,
                                            RestService(context.getCluster()))
    if not storage_pool_ids:
        return ItemStatus.PASS, ""
    storage_pool_all_disk = DiskInitServiceFactory(context) \
        .get_pool_init_service().query_all_disks()
    need_replace_cache_disks = get_need_replace_cache_disks(
        storage_pool_all_disk)
    if not need_replace_cache_disks:
        return ItemStatus.PASS, ""
    ssh_service = SshService(context.getNode())
    main_cache_disk_mappings = list()
    for pool_id in disk_context_util.get_disk_belong_pool_ids(context):
        main_cache_disk_mappings.extend(
            disk_info_util.get_mdc_cmd_101_infos(ssh_service, pool_id))
    main_disk_esn = disk_context_util.get_disk_sn(context)
    mapping_cache_disk_sn_list = get_mapping_cache_disks(main_disk_esn,
                                                         main_cache_disk_mappings)
    # 此主存盘在存储池中，此存储池中有故障缓存盘，并且查不到此主存盘的映射关系
    if not mapping_cache_disk_sn_list:
        return ItemStatus.FAILED, resource_service.get_msg(
            "need.preferentially.replace.cache")
    # 否则，只检查映射的缓存，如果这些sn，有任何一个存在故障，则不通过
    for need_replace_cache_disk in need_replace_cache_disks:
        if need_replace_cache_disk.getEsn() in mapping_cache_disk_sn_list:
            return ItemStatus.FAILED, resource_service.get_msg(
                "need.preferentially.replace.cache")
    return ItemStatus.PASS, ""


def get_mapping_cache_disks(main_disk_esn, main_cache_disk_mappings):
    mapping_cache_disk_sn_list = list()
    for mapping_info in main_cache_disk_mappings:
        if mapping_info.get("OSD ESN") == main_disk_esn:
            mapping_cache_disk_sn_list.append(mapping_info.get("CACHE ESN"))
    return mapping_cache_disk_sn_list


def get_need_replace_cache_disks(disks):
    need_replace_cache_disks = list()
    for disk in disks:
        if is_need_replace_cache_disk(disk):
            need_replace_cache_disks.append(disk)
    return need_replace_cache_disks


def is_need_replace_cache_disk(disk):
    if disk.getMediaRole().toString() != "OSD_CACHE":
        return False
    if disk.getStatus() in NEED_REPLACE_CACHE_DISK_STATUS:
        return True
    return False
