#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/08/19
@file: check_storage_pool_use_capacity.py
@function: 检查存储池使用容量
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service, logger_factory
from py.common.service.connection.rest_connection_service import RestService
from py.fusion_storage.common.constant import ClusterRestUri
from py.fusion_storage.common.context import disk_context_util
from py.fusion_storage.common.service.disk_out_storage_pool_service import \
    get_storage_pool_ids

MAX_USED_CAPACITY_RATE = 0.75


def execute(context):
    if not disk_context_util.is_health_main_disk(context):
        return ItemStatus.NOT_INVOLVED, ""
    rest_service = RestService(context.getCluster())
    res_dict = rest_service.exec_get(ClusterRestUri.QUERY_STORAGE_POOL_INFO)
    belong_pool_ids = get_storage_pool_ids(context, rest_service)
    high_rate_pool_dict = dict()
    for pool in res_dict.get("storagePools", []):
        pool_id = pool.get('poolId')
        pool_used_capacity_rate = pool.get('usedCapacityRate')
        if pool.get('poolId') in belong_pool_ids and pool.get(
                'usedCapacityRate') >= MAX_USED_CAPACITY_RATE:
            high_rate_pool_dict[str(pool_id)] = str(pool_used_capacity_rate)
    if bool(high_rate_pool_dict):
        logger = logger_factory.create_logger(__file__)
        logger.error('Check pool use capacity failed. '
                     'high rate pool detail info: {}'
                     .format(str(high_rate_pool_dict)))
        return ItemStatus.NOT_PASS, resource_service.get_msg(
            "check.pool.used.capacity.failed")\
            .format(",".join(high_rate_pool_dict.keys()),
                    str(MAX_USED_CAPACITY_RATE * 100) + "%")
    return ItemStatus.PASS, ""
