#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/09/07
@file: clean_smart_cache_meta_data.py
@function: 清除smartcache
@modify:
"""
from py.common.entity.item_status import ItemStatus
from py.common.service import resource_service
from py.common.service.connection.rest_connection_service import RestService
from py.fusion_storage.common.service.cluster.cluster_info_util \
    import is_ocean_stor_pacific
from py.fusion_storage.common.service.disk_out_storage_pool_service import \
    get_storage_pool_ids
from py.fusion_storage.common.service.os_util import disk_info_util


def execute(context):
    """
    清除smartcache
    810之前不涉及，开关未打开直接通过
    """
    service = RestService(context.getCluster())
    if not is_ocean_stor_pacific(context):
        return ItemStatus.NOT_INVOLVED, ""
    storage_pool_ids = get_storage_pool_ids(context, service)
    err_msg = list()
    involved_pool_list = list()
    for storage_pool_id in storage_pool_ids:
        if not disk_info_util.smart_cache_switch_is_on(service,
                                                       storage_pool_id):
            involved_pool_list.append(storage_pool_id)
            continue
        flag, description = disk_info_util.clean_smart_cache(service,
                                                             storage_pool_id)
        if flag:
            continue
        err_msg.append(resource_service.get_msg(
            "clean.smart.cache.meta.data.failed").format(storage_pool_id,
                                                         description))
    if len(storage_pool_ids) == len(involved_pool_list):
        return ItemStatus.NOT_INVOLVED, ""
    if err_msg:
        return ItemStatus.NOT_PASS, "\n".join(err_msg)
    return ItemStatus.PASS, ""
