#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.

"""
@version: SmartKit 23.0.0.1
@time: 2023/08/10
@file: process_node_check.py
@function:
@modify:
"""
import re

from py.fusion_storage.common.context import disk_context_util
from py.common.entity.item_status import ItemStatus
from py.common.service.connection.ssh_connection_service import SshService, Cmd
from py.fusion_storage.module.disk.item.process_node import pre_processing, post_processing
from py.common.service import logger_factory
from py.common.service.auto_brush_item_progress import auto_brush_progress

SUPPORT_VERSION_LIST = ["8.0.1", "8.1.0", "8.1.1", "8.1.2", "8.1.3"]


# 检查存储版本是否为适用本检查项的版本
def check_product_version_validity(context):
    product_version = context.getFruDevice().getBusinessDevice().getDevNode().getProductVersion()
    return any([valid_version in product_version for valid_version in SUPPORT_VERSION_LIST])


def check_pre_processing(context):
    ssh_service = SshService(context.getNode())
    disk_num_cmd = 0
    disk_num_file = 0
    logger = logger_factory.create_logger(__file__)
    if not check_product_version_validity(context):
        return ItemStatus.NOT_INVOLVED
    if ssh_service.is_mini_system or ssh_service.is_sandbox_open:
        return ItemStatus.NOT_INVOLVED
    pool_ids = disk_context_util.get_disk_belong_pool_ids(context)
    for pool_id in pool_ids:
        flush_file = "/opt/fusionstorage/persistence_layer/osd/tmp/osd_{}_list_for_flush_metadata.cfg".format(pool_id)
        flush_file_result = ssh_service.exec_cmd(Cmd("ls {}".format(flush_file)))
        flush_file_result = flush_file_result.splitlines()[1]
        if flush_file_result != flush_file:
            flush_file = "/opt/fusionstorage/persistence_layer/osd/conf/osd_{}_list_for_flush_metadata.cfg".format(pool_id)
        disk_esn = ssh_service.exec_cmd(Cmd(
            "cat {} | tail -1 | awk -F\" \" \'{{print $3}}\'".format(flush_file)))
        disk_esn = disk_esn.splitlines()[1]
        storage_ip = ssh_service.exec_cmd(Cmd(
            "mdc_cmd.sh 101 | grep -awF {} | awk -F\"|\" \'{{print $14}}\' | \
            awk -F\" \" \'{{print $1}}\' | sed \'s/:/_/g\'".format(disk_esn)))
        storage_ip = storage_ip.splitlines()[1]
        disk_num_cmd = ssh_service.exec_cmd(Cmd(
            "mdc_cmd.sh 101 | sed \'s/:/_/g\' | grep -awF {} | grep -av dsware_insight | \
            grep -av mdc_id  | wc -l".format(storage_ip)))
        disk_num_cmd = disk_num_cmd.splitlines()[1]
        disk_num_file = ssh_service.exec_cmd(Cmd("cat {} | wc -l".format(flush_file)))
        disk_num_file = disk_num_file.splitlines()[1]
        if disk_num_cmd != disk_num_file:
            logger.error("total {} disk, but flushed {} disk, some disk no flush".format(disk_num_cmd, disk_num_file))
            return ItemStatus.FAILED
    return ItemStatus.SUCCESS


# 检查预处理结果检查项超时时间20min, 20 * 60 = 1200s
@auto_brush_progress(1200)
def check_pre_processing_result(context):
    retry_times = 0
    while retry_times < 3:
        result = check_pre_processing(context)
        if result != ItemStatus.FAILED:
            return result, ""
        result, message = post_processing(context)
        if result != ItemStatus.SUCCESS:
            return result, message
        result, message = pre_processing(context)
        if result != ItemStatus.SUCCESS:
            return result, message
        retry_times += 1
    return ItemStatus.FAILED, resource_service.get_msg("failed.process_check.node")