#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2021. All rights reserved.

"""
@version: SmartKit V200R007C00
@time: 2021/05/31
@file: query_disk_info.py
@function: 查询设备所有硬盘信息，用于UI展示和后续的更换选取
"""
import traceback

from py.common.entity.exception import BusinessException
from py.common.entity.item_status import ItemStatus
from py.common.service import logger_factory
from py.fusion_storage.common import constant
from py.fusion_storage.common.context import disk_context_util
from py.fusion_storage.common.service.disk_init_factory.init_service_factory \
    import DiskInitServiceFactory


def execute(context):
    try:
        match_service = DiskInitServiceFactory(context).get_match_init_service()
        context.initModuleData(match_service.query_cur_module_disks())
        # 更换缓存盘时需要选择对应待加入存储池的主存盘，此时需要刷新主存盘信息
        if disk_context_util.is_cache_module(context):
            pool_service = DiskInitServiceFactory(
                context).get_pool_init_service()
            context.initModuleDataByModuleId(
                constant.Module.MAIN_DISK,
                pool_service.query_assign_module_disks(
                    constant.Module.MAIN_DISK))
        return ItemStatus.SUCCESS, ""
    except BusinessException as ex:
        logger_factory.create_logger(__file__).error(
            "query disk failed, cur module is {}, {}".format(
                context.getModuleId(), traceback.format_exc()))
        return ItemStatus.FAILED, ex.err_msg
